/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_13;
import java.io.*; import javax.servlet.http.*; import lotus.domino.*;
import djbuch.kapitel_06.GC;
import djbuch.rssnews.RSSNews;
import djbuch.rssnews.RSSNewsR7;
/**
 * in Servlet umgewandelter Domino Java Agent
 * @author Thomas Ekert
 */
public class RSSNewsServlet extends HttpServlet {

	public void doGet(HttpServletRequest req, HttpServletResponse res)
			throws IOException {
		Session session = null;
		Database db = null;
		Document doc = null;
		PrintWriter out = res.getWriter();
		try {
			NotesThread.sinitThread();
			session = NotesFactory.createSession();
			System.out.println ("Starting RSSNews Servlet");
			db = session.getDatabase(session.getServerName(),
					"djbuch/djbuch.nsf");
			doc = db.createDocument();
			res.setContentType("text/html");
			DJAgentContext agentContext =
				new DJAgentContext(req.getRemoteUser(), db, doc);
//			RSSNews rss = new RSSNews(agentContext);
			RSSNewsR7 rss = new RSSNewsR7(agentContext);
			rss.process();
			out.print(rss.getCode());
			out.flush();
			out.close();
		} catch (NotesException e) {
			e.printStackTrace();
		} finally {
			GC.recycle(session);
			NotesThread.stermThread();
		}
	}

	/**
	 * HTTP Request von POST auf GET umleiten
	 */
	public void doPost(HttpServletRequest req, HttpServletResponse res)
			throws IOException {
		doGet(req, res);
	}

}